<?php if ($setting->is_app_web || $setting->link_google_play || $setting->link_app_store || $setting->link_amazon_app || $setting->link_microsoft_store) { ?>
    <div class="mb-4 col-md-<?php echo $widget->col; ?>">
        <h2 class="title"><?php echo $_LANG['app-download']; ?></h2>

        <?php if ($setting->is_app_web) { ?>
            <div class="card app-card">
                <a href="<?php echo PATH_SYSTEM . 'pwa'; ?>" class="no-ajaxy" aria-label="<?php echo $_LANG['app_web']; ?>"></a>
                <div class="card-body">
                    <div class="flex-shrink-0 icon">
                        <i class="fas fa-globe fa-3x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3 info">
                        <span class="d-block"><?php echo $_LANG['multiplatform']; ?></span>
                        <span class="h4 d-block mb-0"><?php echo $_LANG['app_web']; ?></span>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ($setting->link_google_play) { ?>
            <div class="card app-card">
                <a href="<?php echo $setting->link_google_play; ?>" target="_blank" aria-label="<?php echo $_LANG['available_on']; ?> Google Play"></a>
                <div class="card-body">
                    <div class="flex-shrink-0 icon">
                        <i class="fab fa-google-play fa-3x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3 info">
                        <span class="d-block"><?php echo $_LANG['available_on']; ?></span>
                        <span class="h4 d-block mb-0">Google Play</span>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ($setting->link_app_store) { ?>
            <div class="card app-card">
                <a href="<?php echo $setting->link_app_store; ?>" target="_blank" aria-label="<?php echo $_LANG['available_at']; ?> App Store"></a>
                <div class="card-body">
                    <div class="flex-shrink-0 icon">
                        <i class="fab fa-apple fa-3x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3 info">
                        <span class="d-block"><?php echo $_LANG['available_at']; ?></span>
                        <span class="h4 d-block mb-0">App Store</span>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ($setting->link_amazon_app) { ?>
            <div class="card app-card">
                <a href="<?php echo $setting->link_amazon_app; ?>" target="_blank" aria-label="<?php echo $_LANG['available_at']; ?> Amazon App"></a>
                <div class="card-body">
                    <div class="flex-shrink-0 icon">
                        <i class="fab fa-amazon fa-3x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3 info">
                        <span class="d-block"><?php echo $_LANG['available_at']; ?></span>
                        <span class="h4 d-block mb-0">Amazon App</span>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ($setting->link_microsoft_store) { ?>
            <div class="card app-card" href="#" target="_blank">
                <a href="<?php echo $setting->link_microsoft_store; ?>" target="_blank" aria-label="<?php echo $_LANG['available_at']; ?> Microsoft"></a>
                <div class="card-body">
                    <div class="flex-shrink-0 icon">
                        <i class="fab fa-microsoft fa-3x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3 info">
                        <span class="d-block"><?php echo $_LANG['available_at']; ?></span>
                        <span class="h4 d-block mb-0">Microsoft</span>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
